VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DLXOCX32.OCX"
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   3285
   ClientLeft      =   3405
   ClientTop       =   2025
   ClientWidth     =   5325
   Icon            =   "frmMain.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   3285
   ScaleWidth      =   5325
   Begin VB.CommandButton cmdExit 
      Caption         =   "Exit"
      Height          =   495
      Left            =   3960
      TabIndex        =   6
      Top             =   2640
      Width           =   735
   End
   Begin VB.ComboBox devNum 
      Height          =   315
      Left            =   2640
      TabIndex        =   4
      Text            =   "0"
      ToolTipText     =   "DriverLINX Config Panel Device Number Assigned value"
      Top             =   600
      Width           =   735
   End
   Begin VB.ListBox List1 
      Height          =   840
      Left            =   2640
      TabIndex        =   3
      Top             =   1200
      Width           =   1935
   End
   Begin VB.CommandButton cmdSample 
      Caption         =   "Scan 3 DI channels"
      Enabled         =   0   'False
      Height          =   375
      Left            =   600
      TabIndex        =   1
      Top             =   1200
      Width           =   1695
   End
   Begin VB.CommandButton cmdInit 
      Caption         =   "Initialize"
      Height          =   375
      Left            =   600
      TabIndex        =   0
      Top             =   600
      Width           =   1695
   End
   Begin DlsrLib.DriverLINXLDD LDD 
      Left            =   1680
      Top             =   1920
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin DlsrLib.DriverLINXSR SR 
      Left            =   1080
      Top             =   1920
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.Label Label2 
      Caption         =   "Device Number :"
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   135
      Left            =   2640
      TabIndex        =   5
      Top             =   360
      Width           =   1215
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   " KEITHLEY "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H8000000E&
      Height          =   300
      Left            =   600
      TabIndex        =   2
      Top             =   120
      Width           =   1455
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit ' require variable declaration
' this program was written in VB6 in Win98SE
' it was tested with a KPCI-PIO24 board using KPCIPIO-850A04 version of
' DriverLINX for the KPCI-PIO Series
'
' this example is appropriate for KPCI-PIO24, KPCI-PIO96, KPCI-3160,
' PIO-12, PIO-24, PIO-96J, PIO-SSR Series
'
' it could be appropriate also for the KPCI-3101/2/3/4 but the channel 2
' of those boards has only 7 bits not 8

Private Sub cmdExit_Click()
' unload the driver for each object
SR.Req_DLL_name = ""
LDD.Req_DLL_name = ""
End
End Sub

Private Sub cmdInit_Click()
' get the device number from the form
Dim deviceNumber As Integer
deviceNumber = CInt(devNum.Text)
' open the driver and initialize the hardware
With SR
.Req_DLL_name = "kpcipio"  ' give driver name to avoid Open DriverLINX dialog
.Req_device = deviceNumber
.Req_mode = DL_OTHER
.Req_op = DL_INITIALIZE
.Req_subsystem = DL_DEVICE
.Refresh
End With
If SR.Res_result = DL_NoErr Then
' use of the LDD control is not required
cmdSample.Enabled = True
cmdInit.Enabled = False
LDD.Req_DLL_name = SR.Req_DLL_name
LDD.device = SR.Req_device
LDD.Refresh  ' get fresh data for our SR device
Form1.Caption = LDD.Dev_Model  'from the LDD, determine the model number
Else
SR.Req_op = DL_MESSAGEBOX
SR.Refresh
End If
' the LDD control can inform your application
' about the features of the hardware
'
'in case the channels have been previously used in output direction
' do a configure operation to set them back to input direction
ConfigureChannelforInputMode 0  ' config channel 0, e.g., Port A
ConfigureChannelforInputMode 1
ConfigureChannelforInputMode 2
' however, a read operation can be carried out on a channel configured for output.
' It will return the last written value to that channel by the output
' operation task.  It will not read back the value of the lines.
Form1.SetFocus  ' set focus back to our form
End Sub

Private Sub cmdSample_Click()
' allocate array for the data and some other variables that will be needed
Dim DIData(3) As Byte
Dim dummy As Single
Dim i As Integer
List1.Clear  ' clear the list box
SetupDIScan
SR.Refresh  ' do it
' error check
' if no errors, then
If SR.Res_result = DL_NoErr Then
dummy = SR.VBArrayBufferXfer(0, DIData, DL_BufferToVBArray)
' display the data
For i = 0 To 2
List1.AddItem "chan #:" & Str(i) & " value :  " & Str(DIData(i))
Next i
End If
' since we have only one buffer allocated, VBArrayBufferXfer is hard coded
' to convert buffer 0.  See DriverLINX docs for more info on methods of the SR control
End Sub

Private Sub Form_Load()
' center the form
   With Form1
        ' Center the form on the screen
        .Left = (Screen.Width - .Width) / 2
        .Top = (Screen.Height - .Height) / 2
   End With
' populate combo box with legal device numbers
Dim i As Integer
For i = 0 To 5
devNum.AddItem Str(i), i
Next i
' set it equal to first entry
devNum.ListIndex = 0
End Sub


Sub SetupDIScan()
With SR
' Request Group
.Req_op = DL_START
.Req_mode = DL_POLLED  ' no pacing clock involved
.Req_subsystem = DL_DI
' Event Group
.Evt_Str_type = DL_COMMAND  ' start when .Refresh is called
.Evt_Stp_type = DL_TCEVENT  ' stop automatically
.Evt_Tim_type = DL_NULLEVENT  ' no timing for Polled mode
' Select Group
.Sel_chan_format = DL_tNATIVE  ' use the card's native format
.Sel_chan_N = 2                ' a start channel and stop channel
.Sel_chan_start = 0            ' start on channel 0
.Sel_chan_stop = 2             ' stop on channel 2
' allocate one buffer of 3 samples for the data
.Sel_buf_N = 1                 ' one buffer used
.Sel_buf_samples = 3
' the buffer MUST be a multiple of how many channels are in the scan
End With
' in polled mode each channel of a sub system (AI, DI, etc) can be
' read (written) one time per scan.  Use a paced mode operation (IRQ or DMA) for
' more than one reading from the channel(s).
End Sub

Sub ConfigureChannelforInputMode(ByVal chan As Integer)
With SR
.Req_subsystem = DL_DI  ' assign the channel the DL_DI subsystem
.Req_mode = DL_OTHER
.Req_op = DL_CONFIGURE
.Evt_Tim_type = DL_DIOSETUP
.Evt_Tim_dioChannel = chan
.Evt_Tim_dioMode = DL_DIO_BASIC
.Refresh
End With
End Sub
